/************************************************************************
 * NAME:	fsinit.c()
 *
 * DESCR:	Init routines for the file system.
 *
 * NOTES:	
 ************************************************************************/
#include "ados.h"
#include "standard.h"
#include "init.h"
#include "marshalling.h"

/************************************************************************
 * NAME:	ados33_init()
 *
 * DESCR:	Initialize the Apple DOS 3.3 file system.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	- the file system structure must already be allocated.
 ************************************************************************/
int
ados33_init(struct adosfs	*adosfs,
	    adosdevice		device, 	/* abstracts floppy struct	*/
	    adosreadfn		readblkfn, 	/* read/write to floppy struct	*/
	    adoswritefn		writeblkfn)
{
    adosfs->type = DOS33;
    adosfs->device = device;
    adosfs->preadsec = readblkfn;
    adosfs->pwritesec = writeblkfn;

    return(TRUE);
}

int
ados33_cleanup(struct adosfs *adosfs)
{
    return(TRUE);
}

ados33_settings(struct adosfs *adosfs,
		int	       startsect,	/* physical starting sector	*/
		int	       openfiles)	/* max open files		*/
{
    adosfs->startsec = startsect;

    if ((adosfs->vtoc = ados_vtoc_read(adosfs)) == NULL) {
	return(FALSE);
    }

    if ((adosfs->catalog = ados_catalog_read(adosfs)) == NULL) {
	ados_vtoc_destroy(adosfs->vtoc);
	return(FALSE);
    }

    if (!ados_fileio_init(adosfs,openfiles)) {
	ados_vtoc_destroy(adosfs->vtoc);
	ados_catalog_destroy(adosfs->catalog);
	return(FALSE);
    }

    return(TRUE);
}
